# cdbx - CDB Reimplementation for Python

TABLE OF CONTENTS
-----------------

1. Introduction
1. Development Status
1. Copyright and License
1. System Requirements
1. Installation
1. Documentation
1. Bugs
1. Author Information


## INTRODUCTION

**cdbx** is a [CDB](https://cr.yp.to/cdb.html) reimplementation for Python.

* [Change Log](CHANGES)
* [Development](docs/DEVELOPMENT.md)


## DEVELOPMENT STATUS

Beta.


## COPYRIGHT AND LICENSE

Copyright 2016 - 2025
André Malo or his licensors, as applicable.

The whole package is distributed under the Apache License Version 2.0.
You'll find a copy in the root directory of the distribution or online
at: <http://www.apache.org/licenses/LICENSE-2.0>.


## SYSTEM REQUIREMENTS

Supported python versions are 2.7 and 3.6+.

You also need a build environment for python C extensions (i.e. a compiler
and the python development files).


## INSTALLATION

### Using pip

```
$ pip install cdbx
```


### Using distutils

Download the package, unpack it, change into the directory

```
$ python setup.py install
```

The command above will install a new "cdbx" package into python's
library path.


## DOCUMENTATION

You'll find a user documentation in the `docs/userdoc/` directory of the
distribution package. Further, there's an api documentation, which can be found
in the docs/apidoc/ subdirectory.

The latest documentation is also available online at
<http://opensource.perlig.de/cdbx/>.


## BUGS

No bugs, of course. ;-)

But if you've found one or have an idea how to improve cdbx, feel free to
send a pull request on [github](https://github.com/ndparker/cdbx) or
send a mail to <cdbx-bugs@perlig.de>.


## AUTHOR INFORMATION

André "nd" Malo <nd@perlig.de>, GPG: 0x029C942244325167


>  If God intended people to be naked, they would be born that way.
>                                                   -- Oscar Wilde
